<?php
if (!class_exists('MoreNews_Posts_lists')) :
    /**
     * Adds MoreNews_Posts_lists widget.
     */
    class MoreNews_Posts_lists extends MoreNews_Widget_Base
    {
        /**
         * Sets up a new widget instance.
         *
         * @since 1.0.0
         */
        function __construct()
        {
            $this->text_fields = array(
                'morenews-posts-list-title',
                'morenews-posts-slider-number'
                
            );
            $this->select_fields = array(

                'morenews-select-category',
                
            );

            $widget_ops = array(
                'classname' => 'morenews_posts_lists_widget',
                'description' => __('Displays grid from selected categories.', 'morenews'),
                'customize_selective_refresh' => false,
            );

            parent::__construct('morenews_posts_list', __('AFTMN Post List', 'morenews'), $widget_ops);
        }

        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args Widget arguments.
         * @param array $instance Saved values from database.
         */

        public function widget($args, $instance)
        {

            $instance = parent::morenews_sanitize_data($instance, $instance);


            /** This filter is documented in wp-includes/default-widgets.php */

            $title_1 = apply_filters('widget_title', $instance['morenews-posts-list-title'], $instance, $this->id_base);
    

            $morenews_category = !empty($instance['morenews-select-category']) ? $instance['morenews-select-category'] : '0';


            $color_class = '';
            if(absint($morenews_category) > 0){
                $color_id = "category_color_" . $morenews_category;
                // retrieve the existing value(s) for this meta field. This returns an array
                $term_meta = get_option($color_id);
                $color_class = ($term_meta) ? $term_meta['color_class_term_meta'] : 'category-color-1';
            }


            // open the widget container
            echo $args['before_widget'];
            ?>
                <section class="aft-blocks aft-featured-category-section af-list-post featured-cate-sec pad-v">
                    <?php if (!empty($title_1)): ?>
                        <?php morenews_render_section_title($title_1, $color_class); ?>
                    <?php endif; ?>
                    <?php $morenews_all_posts_vertical = morenews_get_posts(6, $morenews_category); ?>

                    <div class="full-wid-resp af-widget-body af-container-row clearfix">
                        <?php
                            if ($morenews_all_posts_vertical->have_posts()) :
                                while ($morenews_all_posts_vertical->have_posts()) : $morenews_all_posts_vertical->the_post();
                                    global $post;

                                    ?>
                                    <div class="pad float-l col-2">
                                        <?php do_action('morenews_action_loop_list', $post->ID, 'thumbnail', 0, false, true, false); ?>
                                    </div>
                                <?php
                                endwhile;
                            endif;
                            wp_reset_postdata();
                        ?>
                    </div>
                </section>
            <?php
            // close the widget container
            echo $args['after_widget'];
        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         * @param array $instance Previously saved values from database.
         */
        public function form($instance)
        {
            $this->form_instance = $instance;


            //print_pre($terms);
            $categories = morenews_get_terms();
            


            if (isset($categories) && !empty($categories)) {
                // generate the text input for the title of the widget. Note that the first parameter matches text_fields array entry
                echo parent::morenews_generate_text_input('morenews-posts-list-title', __('Title', 'morenews'), 'Posts List');
                echo parent::morenews_generate_select_options('morenews-select-category', __('Select Category', 'morenews'), $categories);

            }

            //print_pre($terms);


        }

    }
endif;